'use client';

import React from 'react';
import { useParams } from 'next/navigation';
import EventForm from '@/components/events/EventForm';

export default function EditEventPage() {
    const params = useParams();
    const eventId = params.id as string;

    return (
        <div className="min-h-screen bg-gray-50 p-8" dir="rtl">
            <div className="max-w-4xl mx-auto">
                <div className="mb-6">
                    <h1 className="text-3xl font-bold text-gray-900">ערוך אירוע</h1>
                </div>

                <EventForm
                    mode="edit"
                    eventId={eventId}
                    onSuccess={() => {
                        window.location.href = `/events/${eventId}`;
                    }}
                />
            </div>
        </div>
    );
}
